#include <bits/stdc++.h>
#define ff first
#define ss second
#ifndef LOCAL
#define endl '\n'
#endif
//#define int long long

using namespace std;

typedef long long ll;
typedef long double ld;

const int inf = 1000000009;
const ll inf18 = 1000000000000000018;

template <class T1, class T2> istream& operator>>(istream& is, pair <T1, T2>& a) {return is >> a.ff >> a.ss;}
template <class T1, class T2> ostream& operator<<(ostream& os, pair <T1, T2> a) {return os << "(" << a.ff << ", " << a.ss << ")";}
template <class T> istream& operator>>(istream& is, vector <T>& a) {for (auto &x : a) is >> x; return is;}
template <class T> ostream& operator<<(ostream& os, vector <T> a) {for (auto x : a) os << x << " "; return os << endl;}

template <int M>
struct Modular{
    int v;
    Modular() {v = 0;}
    Modular(int x) {v = x;}
    Modular(ll x) {v = x % M;}

    Modular& operator+=(Modular a) {v += a.v; if (v >= M) v -= M; return *this;}
    Modular& operator-=(Modular a) {v -= a.v; if (v < 0) v += M; return *this;}
    Modular operator*=(Modular a) {v = 1ll * v * a.v % M; return *this;}
    friend Modular operator+(Modular a, Modular b) {return a += b;}
    friend Modular operator-(Modular a, Modular b) {return a -= b;}
    friend Modular operator*(Modular a, Modular b) {return a *= b;}
    friend Modular operator-(Modular a) {return 0 - a;}

    static Modular binpow(Modular x, ll y) {Modular c = 1; while (y) {if (y & 1) c *= x; y >>= 1, x *= x;} return c;}
    static Modular inverse(Modular x) {return binpow(x, M - 2);}

    friend istream& operator>>(istream& is, Modular& a) {return is >> a.v;}
    friend ostream& operator<<(ostream& os, Modular a) {return os << a.v;}

    friend bool operator==(Modular const& a, Modular const& b) {return a.v == b.v;}
    friend bool operator!=(Modular const& a, Modular const& b) {return a.v != b.v;}
    friend bool operator<(Modular const& a, Modular const& b) {return a.v < b.v;}
};
const int M = 998244353;
using mint = Modular <M>;

const int N = 5010;
mint dp[N], p[N], ans[N];

void solve(){
    int n, m;
    cin >> n >> m;
    dp[0] = 1;
    p[1] = 1;
    for (int len = 1; len <= n; len++){
        for (int i = 1; i <= n; i++){
            dp[i] = (p[i] - p[max(0, i - len)]) * (m - 1) + (i <= len ? 1 : 0);
            p[i + 1] = p[i] + dp[i];
        }
        ans[len] = dp[n];
    }
    for (int len = n; len >= 2; len--) ans[len] -= ans[len - 1];
    mint val = 0;
    for (int len = 1; len <= n; len++) val += ans[len] * len;
    val *= mint::inverse(mint::binpow(m, n));
    cout << val << endl;
}

int32_t main(){
#ifdef LOCAL
    auto start = clock();
#else
    ios_base::sync_with_stdio(false); cin.tie(0);
#endif
    int ttt = 1;
    cin >> ttt;
    while (ttt--) solve();
#ifdef LOCAL
    cout << endl << "TIME: " << (clock() - start) * 1.0 / CLOCKS_PER_SEC << " sec" << endl;
#endif
}